<?php

namespace App\Admin\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use Encore\Admin\Controllers\Dashboard;
use Encore\Admin\Layout\Column;
use Encore\Admin\Layout\Content;
use Encore\Admin\Layout\Row;

class HomeController extends Controller
{
    public function index(Content $content)
    {
        $count_user = User::count();

        return $content
            ->title('Dashboard')
//            ->description('Description...')
            ->row(Dashboard::title())
            ->row(function (Row $row)use($count_user)  {



            }) ->row(function (Row $row) use($count_user) {
                $row->column(7, function (Column $column) use($count_user){
                    $day_number = date('t');
                    $days=[];
                    $day_name=[];
                    for($i=0; $i<= $day_number; $i++){
                        $cound = User::whereRaw('date(created_at) = "'. date('Y-m-').$i .'"' )->count();
                        $days[$i] = $cound;
                        $day_name[$i] = $i+1;
                    }

                    $column->append(view('chart',['day_name'=>$day_name,'days'=>$days,'count_user'=>$count_user]));
                });
                $row->column(3, function (Column $column)  use($count_user){

                    $column->append(view('counter_widget',['title'=>'Number of user','count'=>$count_user]));
                });


                $row->column(12, function (Column $column) {
                    $user=user::orderBy('id', 'desc') ->limit(10)->get();;


                    $column->append(view('table',['user'=>$user]));
                });

            });
    }
}
