<?php

namespace App\Http\Controllers;

use App\Http\Requests\ResetPasswordRequest;
use App\Models\ForgotPassword;
use App\Models\User;
use http\Env\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


class ForgotPasswordController extends Controller
{
    public function index(Request $request){

        $emailuser = $request->email;
        $token = Str::random(60);
        $user=User::where('email',$emailuser)->first();
        if(!$user){
            return Response()->json(['message'=>'user dose not exist',],422);
        }else
            {
//        $forgotpass = ForgotPassword::create([
//        'email' => $request['email'],
//        'token'=>$code
//        ]);
            $model = new ForgotPassword();
            $model->email = $request->email;
            $model->token = $token;
            $model->save();

        $user->sendPasswordResetNotification($model->token);


        return Response()->json(['message'=>'hast','code'=>$token],200);
            }


    }


    public function checktoken(Request $request)
    {
        $token=ForgotPassword::where(['token'=>$request->token])->first();

        if (!$token)
        {
            return "not font";
        }else{

            return view('reset',compact('token'));
        }
    }


    public function ResetPassword(ResetPasswordRequest $request){

        $res = ForgotPassword::where('token',$request->token)->first();
        $user= User::where('email',$res->email)->first()->update([
            'password'=>Hash::make($request->password),
            ]);
        return view('success');
    }

}
